﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace GeneralQuizzer
{
    interface IQuizObject
    {
        string GetQuestion();
        bool CheckAnswer(string answer);
        void NextQuestion();
    }

    class FakeWrongQuiz : IQuizObject
    {
        public bool CheckAnswer(string answer)
        {
            return false;
        }

        public string GetQuestion()
        {
            return "Odpowiedź na to pytanie jest zawsze niepoprawna.";
        }

        public void NextQuestion()
        {
        }

        public override string ToString()
        {
            return "Quiz zawsze nieprawidłowy";
        }

    }

    abstract class CalculationQuizObject : IQuizObject
    {
        protected Random rand = new Random();

        protected string currentQuestion;

        protected int currentAnswer;

        public string GetQuestion()
        {
            return currentQuestion;
        }

        public bool CheckAnswer(string answer)
        {
            int answerValue;
            if (int.TryParse(answer, out answerValue))
            {
                if (answerValue == currentAnswer)
                    return true;
            }
            return false;
        }

        public abstract void NextQuestion();
    }

    class AdditionQuizObject : CalculationQuizObject
    {

        public override void NextQuestion()
        {
            int firstNum = rand.Next(0, 10);
            int secondNum = rand.Next(0, 10);
            currentQuestion = "Ile jest " + firstNum + " + " + secondNum + "?";
            currentAnswer = firstNum + secondNum;
        }

        public AdditionQuizObject()
        {
            NextQuestion();
        }

        public override string ToString()
        {
            return "Quiz z dodawania";
        }
    }

    class SubtractionQuizObject : CalculationQuizObject
    {
        public override void NextQuestion()
        {
            int firstNum = rand.Next(0, 10);
            int secondNum = rand.Next(0, 10);
            currentQuestion = "Ile jest " + firstNum + " - " + secondNum + "?";
            currentAnswer = firstNum - secondNum;
        }

        public SubtractionQuizObject()
        {
            NextQuestion();
        }

        public override string ToString()
        {
            return "Quiz z odejmowania";
        }
    }

    class MultiplicationQuizObject : CalculationQuizObject
    {
        public override void NextQuestion()
        {
            int firstNum = rand.Next(0, 10);
            int secondNum = rand.Next(0, 10);
            currentQuestion = "Ile jest " + firstNum + " * " + secondNum + "?";
            currentAnswer = firstNum * secondNum;
        }

        public MultiplicationQuizObject()
        {
            NextQuestion();
        }

        public override string ToString()
        {
            return "Quiz z mnożenia";
        }
    }

    class DivisionQuizObject : CalculationQuizObject
    {
        public override void NextQuestion()
        {
            int firstNum = rand.Next(1, 10);
            int secondNum = rand.Next(1, 10);
            int product = firstNum * secondNum;
            currentQuestion = "Ile jest " + product + " / " + firstNum + "?";
            currentAnswer = secondNum;
        }

        public DivisionQuizObject()
        {
            NextQuestion();
        }

        public override string ToString()
        {
            return "Quiz z dzielenia";
        }
    }
}
